<?php
namespace ZS\Usaepay\Model;

use ZS\Usaepay\Model\ResourceModel\Card as ResourceModel;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Card
 * @package Merchantesolutions\Gateway\Model
 */
class Card extends AbstractModel
{

    /** @var string */
    protected $_idFieldName = 'card_id';

    /** @var \Magento\Framework\Stdlib\DateTime\DateTime */
    private $date;

    /**
     * Card constructor.
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Stdlib\DateTime\DateTime $date
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Stdlib\DateTime\DateTime $date,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->date = $date;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * Sets created_at/updated_at values
     * @return void
     */
    public function beforeSave()
    {
        parent::beforeSave();
        if($this->isObjectNew() && !$this->hasData('created_at')) {
            $this->setData('created_at', $this->date->date());
        }
        $this->setData('updated_at', $this->date->date());
    }

}